	function wsT = CH_wsT_Z(N, wcT, Amax, Amin)
	
	% 	Computes wsT for a lowpass digital Chebyshev I and II filter of order N
	
	% 	Toolbox for DIGITAL FILTERS USING MATLAB
	
	% 	Author: 		Tapio Saramaki, 2018-03-10
	% 	Modified by: 	LW, 2018-04-04
	% 	Version: 		1
	% 	Known bugs:		
	% 	Report bugs to:	tapio.saramaki@tut.fi	
	
	if N ~= round(N)
		disp([ 'Must be an integer'])
		break
	end
	JJ = (10^(Amin/10)-1)/(10^(Amax/10)-1);
    Ome = cosh(acosh(sqrt(JJ))/N);
	wsT = 2*atan(Ome*tan(wcT/2))/pi; 		
	
